# Gitaly Team specific onboarding

Welcome to [Gitaly Team](https://about.gitlab.com/handbook/engineering/development/enablement/systems/gitaly/)!!

The following items are the team-specific extension of your onboarding issue.
Please complete all but the "Reading material" section in your first few working days.

- Join Slack channels:
  - [ ] [#gitaly-lounge](https://gitlab.slack.com/archives/gitaly-lounge) (internal team affairs, generic informal chat)
  - [ ] [#g_gitaly](https://gitlab.slack.com/archives/g_gitaly) (important communication also outside the team)
  - [ ] [#git-core](https://gitlab.slack.com/archives/git-core) (conversations re git itself)
  - [ ] [#s_enablement](https://gitlab.slack.com/archives/s_enablement) (section-wide communication)
  - [ ] [#gitaly-alerts](https://gitlab.slack.com/archives/gitaly-alerts) (Alerts for gitaly releases and failures)
- Ask your manager or your mentor in order to:
  - [ ] get Maintainer access to the [@gl-gitaly](https://gitlab.com/groups/gl-gitaly/-/group_members) group
  - [ ] be added to the weekly team meeting and [meeting notes](https://docs.google.com/document/d/1k1hY0ZdeFUnSqF6GUToFaJEtVIN_SjWeaRdx1V0i25E/edit)
  - [ ] be added to [Geekbot](https://app.geekbot.com/dashboard) for daily Slack standup updates
  - [ ] get Maintainer access to the [Gitaly Retrospective](https://gitlab.com/gl-retrospectives/enablement-section/gitaly) respository
  - [ ] get access to the [Gitaly Group calendar](https://calendar.google.com/calendar/embed?src=gitlab.com_mc911ncuk38bfngud133tjb4m8%40group.calendar.google.com&ctz=Europe%2FZurich), then add it by clicking [here](https://calendar.google.com/calendar/u/0?cid=Z2l0bGFiLmNvbV9tYzkxMW5jdWszOGJmbmd1ZDEzM3RqYjRtOEBncm91cC5jYWxlbmRhci5nb29nbGUuY29t)
- Acquire necessary access:
  - [ ] join the @gitalyteam Slack group ([example](https://gitlab.com/gitlab-com/team-member-epics/access-requests/-/issues/15868))
  - [ ] get access to [Stackdriver](https://about.gitlab.com/handbook/engineering/monitoring/#go-services)
  - [ ] join the `gcp-host-profiles-sg@gitlab.com` GCP group for access to [periodic profiling data](https://gitlab.com/gitlab-com/gl-infra/scalability/-/issues/1433#note_901717231)
    - [ ] create an [Access request](https://about.gitlab.com/handbook/business-technology/end-user-services/onboarding-access-requests/access-requests/). An example is [here](https://gitlab.com/gitlab-com/team-member-epics/access-requests/-/issues/24746)
  - [ ] request access to [Zendesk](https://about.gitlab.com/handbook/support/internal-support/#requesting-a-zendesk-light-agent-account)
  - [ ] join the https://groups.google.com/a/gitlab.com/g/eng-dev-trace-gitaly/members Google group to be able to use [GCP tracing](https://gitlab.com/gitlab-com/team-member-epics/access-requests/-/issues/21356)
  - [ ] Log in to [Sentry](https://new-sentry.gitlab.net/settings/gitlab/teams/) via Okta and join the `#gitlab` group. This should allow you to view events and statistics related to Gitaly production.
- If transferring from another team within GitLab:
  - [ ] update your [Team page entry](https://about.gitlab.com/handbook/git-page-update/#12-add-yourself-to-the-team-page)
  - [ ] update your Slack profile ("What I do")
  - [ ] update your Zoom title
- Integrate your PTO with the Gitaly Team Calendar
  - [ ]  [follow these instructions](https://about.gitlab.com/handbook/people-group/engineering/team-pto-calendar/#steps), and use `gitlab.com_mc911ncuk38bfngud133tjb4m8@group.calendar.google.com` as the Calendar ID.
- Reading material
  - [ ] check out the [README](https://gitlab.com/gitlab-org/gitaly/-/blob/master/README.md) at https://gitlab.com/gitlab-org/gitaly, without getting lost in too much detail
  - [ ] visit the [Gitaly Training & Resources Youtube channel](https://youtube.com/playlist?list=PL05JrBw4t0KqPMCB7xW1ExIRp6YuD_7_N)
        for videos on how Gitaly works.
  - [ ] checkout the Gitaly doc [README](https://gitlab.com/gitlab-org/gitaly/-/blob/master/doc/README.md)
  - [ ] familiarize yourself with the [Merge request workflow](https://docs.gitlab.com/ee/development/contributing/merge_request_workflow.html) specific to working _on_ GitLab (the whole page)
  - [ ] check out the [team page](https://about.gitlab.com/handbook/engineering/development/enablement/systems/gitaly/)
     - [ ] for day-to-day work, get familiar with how we [schedule work](https://about.gitlab.com/handbook/engineering/development/enablement/systems/gitaly/#working-with-product). It may be useful to bookmark the [Gitaly ongoing work issue board](https://gitlab.com/groups/gitlab-org/-/boards/1140874?label_name%5B%5D=group%3A%3Agitaly&milestone_title=Upcoming)
     - [ ] for the big picture, see the team [vision and roadmap](https://about.gitlab.com/handbook/engineering/development/enablement/systems/gitaly/#roadmap) (click through on the links)

/confidential
/assign me
/cc @andrashorvath @jcaigitlab
